;;  Programm:      ACM-TRANPASSEN.LSP
;;  Befehlsaufruf: ACM-TRANPASSEN
;;  Funktion:      Weist Objekten eine Transparenz zu.
;;  Autor:         Gerhard Rampf
;;                 Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;                 Liebigstr. 3 A
;;                 86399 Bobingen
;;                 E-Mail: rampf@geracad.de
;;  Datum:         04.01.2023
;;  Plattform:     Alle AutoCAD-Versionen ab Version 2011
(defun c:acm-tranpassen ( / bvc41 bvc42 bvc12 bvc43 bvc44 bvc40 cvb01 cvb02 cvb03 cvb04 cvb05 cvb06 cvb07 cvb08 cvb09 cvb10 cvb11)
    (defun cvb01 ( / bvc06 bvc07)
      (setq bvc06 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= bvc06 "AUTOCAD")
            (getvar "TRANSPARENCYDISPLAY")
          )
            (setq bvc07 T)
            (setq bvc07 nil)
        )
        (if (not bvc07)
          (alert "\042acm-tranpassen\042 kann nur unter AutoCAD ab Version 2011 verwendet werden.")
        )
      bvc07
    )
    (defun cvb02 (bvc01 / bvc08 bvc09)
        (if
          (and
            (getvar "CETRANSPARENCY")
            (tblsearch "LAYER" bvc01)
            (= (type bvc01) 'STR)
          )
            (progn
              (if (not (setq bvc08 (cdr (assoc 1071 (cdr (car (cdr (assoc -3 (entget (tblobjname "LAYER" bvc01) '("AcCmTransparency"))))))))))
                (setq bvc08 0)
                (progn
                  (if (setq bvc09 (vl-position bvc08 (list 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 33554687 33554684 33554681 33554679 33554676 33554674 33554671 33554669 33554666 33554664 33554661 33554658 33554656 33554653 33554651 33554648 33554646 33554643 33554641 33554638 33554636 33554633 33554630 33554628 33554625 33554623 33554620 33554618 33554615 33554613 33554610 33554607 33554605 33554602 33554600 33554597 33554595 33554592 33554590 33554587 33554585 33554582 33554579 33554577 33554574 33554572 33554569 33554567 33554564 33554562 33554559 33554556 33554554 33554551 33554549 33554546 33554544 33554541 33554539 33554536 33554534 33554531 33554528 33554526 33554523 33554521 33554518 33554516 33554513 33554511 33554508 33554505 33554503 33554500 33554498 33554495 33554493 33554490 33554488 33554485 33554483 33554480 33554477 33554475 33554472 33554470 33554467 33554465 33554462 33554460 33554457)))
                    (setq bvc08 (nth bvc09 (list 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90)))
                    (setq bvc08 (fix (- 100 (/ (lsh (lsh bvc08 24) -24) 2.55))))
                  )
                )
              )
            )
        )
        (if
          (or
            (not bvc08)
            (< bvc08 0)
            (> bvc08 90)
          )
            (setq bvc08 0)
        )
      bvc08
    )
    (defun cvb03 (bvc02 / bvc10 bvc11)
        (if (= (type bvc02) 'ENAME)
          (setq bvc02 (vlax-ename->vla-object bvc02))
        )
      (setq bvc10 (vlax-get bvc02 'EntityTransparency))
        (if (vl-string-search "LAYER" (strcase bvc10))
          (setq bvc11 -1)
        )
        (if (vl-string-search "BLOCK" (strcase bvc10))
          (setq bvc11 -2)
        )
        (if (not bvc11)
          (setq bvc11 (atoi bvc10))
        )
      bvc11
    )
    (defun cvb04 (bvc03 / )
      (if bvc12 (setq *error* bvc12))
      (if bvc41 (setvar "CMDECHO" bvc41))
      (if bvc33 (setvar "PICKBOX" bvc33))
      (setq bvc12 nil bvc41 nil bvc33 nil)
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
      (princ)
    )
    (defun cvb05 (bvc04 bvc05 / bvc13 bvc14 bvc15 bvc16)
      (setq bvc13 (list -1 -2 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90))
      (setq bvc14 (list "_bylayer" "_byblock" "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79" "80" "81" "82" "83" "84" "85" "86" "87" "88" "89" "90"))
      (setq bvc15 (list "VonLayer" "VonBlock" "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79" "80" "81" "82" "83" "84" "85" "86" "87" "88" "89" "90"))
      (setq bvc16 (nth (vl-position bvc05 bvc13) bvc14))
      (vl-cmdf "._chprop" bvc04 "" "_transparency" bvc16 "")
        (if (vl-position bvc40 (list 0 1))
          (setvar "TRANSPARENCYDISPLAY" bvc40)
        )
      (prompt (strcat "\nTransparenz von " (itoa (sslength bvc04)) " Objekt(en) angepasst. Neue Transparenz: " (nth (vl-position bvc05 bvc13) bvc15) " "))
    )
    (defun cvb06 ( / bvc19 bvc17 bvc18)
      (if
        (and
          (setq bvc17 (vl-filename-mktemp "acm.dcl"))
          (setq bvc18 (open bvc17 "w"))
        )
          (progn
            (setq bvc19
              (list
                "acm_ccs"
                ":dialog{label=\042Einstellungen\042;"
                ":spacer{height=0.2;}"
                ":popup_list{key=\042pl_01\042;label=\042&Pickbox-Gre:\042;edit_width=8;}"
                ":spacer{height=0.3;}"
                ":toggle{key=\042tg_01\042;label=\042&Blockelemente whlbar\042;}"
                ":toggle{key=\042tg_02\042;label=\042&VonLayer ersetzen\042;}"
                ":spacer{height=0.3;}"
                ":row{"
                ":spacer{width=0;}"
                ":column{width=0;fixed_width=true;"
                ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=0;}}}"
              )
            )
              (while bvc19
                (write-line (car bvc19) bvc18)
                (setq bvc19 (cdr bvc19))
              )
            (setq bvc18 (close bvc18))
            bvc17
          )
          nil
      )
    )
    (defun cvb07 ( / bvc20 bvc21 bvc22 bvc25)
        (if (setq bvc20 (cvb06))
          (progn
            (setq bvc21 (load_dialog bvc20))
              (if (not (new_dialog "acm_ccs" bvc21))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list bvc20))
            (start_list "pl_01")
            (mapcar 'add_list (list (strcat "Akt. (" (itoa (getvar "PICKBOX")) ")") "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20"))
            (end_list)
            (set_tile "tg_01" (itoa me3kx5l02sh5-s42))
            (set_tile "tg_02" (itoa me4kx5l02sh5-s42))
              (if (= me1kx5l02sh5-s42 0)
                (set_tile "pl_01" "0")
                (set_tile "pl_01" (itoa me2kx5l02sh5-s42))
              )
              (action_tile "b_01" "(setq bvc22 (atoi (get_tile \"pl_01\")))
                  (if (= bvc22 0)
                    (progn
                      (setq me1kx5l02sh5-s42 0)
                      (setq me2kx5l02sh5-s42 (getvar \"PICKBOX\"))
                    )
                    (progn
                      (setq me1kx5l02sh5-s42 1)
                      (setq me2kx5l02sh5-s42 bvc22)
                    )
                  )
                (setq bvc25 (list (setq me3kx5l02sh5-s42 (atoi (get_tile \"tg_01\"))) (setq me4kx5l02sh5-s42 (atoi (get_tile \"tg_02\"))) me1kx5l02sh5-s42 me2kx5l02sh5-s42))
                (done_dialog)
                (cvb08)"
              )
            (action_tile "b_02" "(setq bvc25 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog bvc21)
          )
        )
      bvc25
    )
    (defun cvb08 ( / )
      (if (not (vl-position me1kx5l02sh5-s42 (list 0 1)))
        (setq me1kx5l02sh5-s42 0)
      )
      (if (not (vl-position me2kx5l02sh5-s42 (list 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20)))
        (progn
          (setq me1kx5l02sh5-s42 0)
          (setq me2kx5l02sh5-s42 (getvar "PICKBOX"))
        )
      )
      (if (not (vl-position me3kx5l02sh5-s42 (list 0 1)))
        (setq me3kx5l02sh5-s42 0)
      )
      (if (not (vl-position me4kx5l02sh5-s42 (list 0 1)))
        (setq me4kx5l02sh5-s42 0)
      )
      (prompt
        (strcat
          "\nAktuelle Einstellungen fr Wahl der Zieltransparenz: Pickbox-Gre = "
            (if (= me1kx5l02sh5-s42 0)
              (strcat "Aktuelle (" (itoa (getvar "PICKBOX")) ")")
              (itoa me2kx5l02sh5-s42)
            )
          ", Blockelemente whlbar = "
          (nth me3kx5l02sh5-s42 (list "Nein" "Ja"))
          ", VonLayer ersetzen = "
          (nth me4kx5l02sh5-s42 (list "Nein" "Ja"))
        )
      )
    )
    (defun cvb09 ( / bvc13 bvc14 bvc29 bvc30 bvc31 bvc32 bvc33 bvc34 bvc35 bvc36 bvc37 bvc38)
      (setq bvc13 (list -1 -2 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90))
        (if (not (vl-position me5kx5l02sh5-s42 bvc13))
          (setq me5kx5l02sh5-s42 -1)
        )
      (setq bvc14 (list "VonLayer" "VonBlock" "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79" "80" "81" "82" "83" "84" "85" "86" "87" "88" "89" "90"))
        (if (/= me5kx5l02sh5-s42 -1)
          (progn
            (setq bvc29 "Vonlayer Auswahlliste Einstellungen")
            (setq bvc30 (strcat "\nZieltransparenz durch Objekt whlen oder [Vonlayer/Auswahlliste/Einstellungen] <" (nth (vl-position me5kx5l02sh5-s42 bvc13) bvc14) ">: "))
          )
          (progn
            (setq bvc29 "Auswahlliste Einstellungen")
            (setq bvc30 "\nZieltransparenz durch Objekt whlen oder [Auswahlliste/Einstellungen] <VonLayer>: ")
          )
        )
      (setq bvc31 (getvar "ERRNO"))
      (setvar "ERRNO" 7)
        (while (= (getvar "ERRNO") 7)
          (setvar "ERRNO" 0)
            (if (= me3kx5l02sh5-s42 0)
              (setq bvc32 entsel)
              (setq bvc32 nentsel)
            )
          (setq bvc33 (getvar "PICKBOX"))
          (setvar "PICKBOX" me2kx5l02sh5-s42)
          (initget bvc29)
          (setq bvc34 (bvc32 bvc30))
          (setvar "PICKBOX" bvc33)
            (if (not bvc34)
              (setq bvc35 me5kx5l02sh5-s42)
              (progn
                (if (= (type bvc34) 'STR)
                  (progn
                    (if (= bvc34 "Vonlayer")
                      (setq bvc35 -1)
                    )
                    (if (= bvc34 "Auswahlliste")
                      (progn
                        (if (not (setq bvc35 (car (cvb11))))
                          (setvar "ERRNO" 7)
                        )
                      )
                    )
                    (if (= bvc34 "Einstellungen")
                      (progn
                        (cvb07)
                        (setvar "ERRNO" 7)
                        (setq bvc36 T)
                      )
                    )
                  )
                  (progn
                    (setq bvc37 (car bvc34))
                    (setq bvc38 (entget bvc37))
                    (setq bvc35 (cvb03 bvc37))
                      (if (= bvc35 -1)
                        (progn
                          (if (= me4kx5l02sh5-s42 0)
                            (setq bvc35 -1)
                            (setq bvc35 (cvb02 (cdr (assoc 8 bvc38))))
                          )
                        )
                      )
                  )
                )
              )
            )
            (if
              (and
                (= (getvar "ERRNO") 7)
                (not bvc36)
              )
                (prompt "0 gefunden")
            )
          (setq bvc36 nil)
        )
        (if bvc31
          (setvar "ERRNO" bvc31)
        )
      (if bvc35
        (setq me5kx5l02sh5-s42 bvc35)
        nil
      )
    )
    (defun cvb10 ( / bvc19 bvc17 bvc18)
      (if
        (and
          (setq bvc17 (vl-filename-mktemp "acm.dcl"))
          (setq bvc18 (open bvc17 "w"))
        )
          (progn
            (setq bvc19
              (list
                "acm_ctr"
                ":dialog{label=\042Zieltransparenz whlen\042;initial_focus=\042lb_01\042;"
                ":spacer{height=0.2;}"
                ":list_box{key=\042lb_01\042;height=12;allow_accept=true;}"
                ":spacer{height=0;}"
                ":toggle{key=\042tg_01\042;label=\042Transparenz &aktivieren\042;}"
                ":spacer{height=0.3;}"
                ":row{"
                ":spacer{width=1;}"
                ":column{width=0;fixed_width=true;"
                ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=1;}}}"
              )
            )
              (while bvc19
                (write-line (car bvc19) bvc18)
                (setq bvc19 (cdr bvc19))
              )
            (setq bvc18 (close bvc18))
            bvc17
          )
          nil
      )
    )
    (defun cvb11 ( / bvc20 bvc21 bvc13 bvc14 bvc39 bvc25)
        (if (setq bvc20 (cvb10))
          (progn
            (setq bvc21 (load_dialog bvc20))
              (if (not (new_dialog "acm_ctr" bvc21))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list bvc20))
            (setq bvc13 (list -1 -2 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90))
              (if (not (vl-position me5kx5l02sh5-s42 bvc13))
                (setq me5kx5l02sh5-s42 -1)
              )
            (setq bvc14 (list "VonLayer" "VonBlock" "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79" "80" "81" "82" "83" "84" "85" "86" "87" "88" "89" "90"))
              (if (not (setq bvc39 (vl-position me5kx5l02sh5-s42 bvc13)))
                (setq bvc39 0)
              )
            (start_list "lb_01")
            (mapcar 'add_list bvc14)
            (end_list)
            (set_tile "lb_01" (itoa bvc39))
            (set_tile "tg_01" (itoa (getvar "TRANSPARENCYDISPLAY")))
            (action_tile "b_01" "(setq bvc40 (atoi (get_tile \"tg_01\"))) (setq me5kx5l02sh5-s42 (nth (atoi (get_tile \"lb_01\")) bvc13)) (setq bvc25 (list me5kx5l02sh5-s42 (atoi (get_tile \"tg_01\")))) (done_dialog)")
            (action_tile "b_02" "(setq bvc25 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog bvc21)
          )
        )
      bvc25
    )
  (if (cvb01)
    (progn
      (vl-load-com)
      (setq bvc41 (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq bvc42 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq bvc12 *error*)
      (setq *error* cvb04)
      (vla-EndUndoMark bvc42)
      (vla-StartUndoMark bvc42)
      (cvb08)
      (prompt "\nMit ACM-TRANPASSEN zu bearbeitende Objekte whlen ... ")
        (if
          (and
            (setq bvc43 (ssget "_:L"))
            (setq bvc44 (cvb09))
          )
            (progn
              (cvb05 bvc43 bvc44)
            )
        )
        (if bvc12
          (setq *error* bvc12)
          (setq *error* nil)
        )
      (setvar "CMDECHO" bvc41)
      (vla-EndUndoMark bvc42)
    )
  )
  (princ)
)
(terpri)
(princ "\nAutoLISP-Tool ACM-TRANPASSEN (Copyright  2023 Gerhard Rampf) geladen.")
(princ "\nRufen Sie den Befehl mit ACM-TRANPASSEN auf.")
